#include "Qt_open.h"

#include "User.h"

#include "Main_window.h"
#include "Project.h"
#include "Model.h"
#include "Model_kit.h"
#include "New_model.h"
#include "Create.h"

#include <QFileDialog>
#include <fstream>

namespace MM
{

void Qt_open::
execute()
{
    QFileDialog     dialog (Main_window::singleton(), "Open file", path ());
    dialog.setMinimumHeight (580);
    dialog.setMinimumWidth  (950);
    dialog.setAcceptMode    (QFileDialog::AcceptOpen);
    dialog.setViewMode      (QFileDialog::List);
    dialog.setFileMode      (QFileDialog::ExistingFiles);

    QStringList filters = list_filters (for_open);
    dialog.setFilters(filters);

    if (dialog.exec())
    {
        QStringList file_names      = dialog.selectedFiles  ();
        selected_filter_            = dialog.selectedFilter ();
        QString     file_type_name  = 
            selected_filter_. section('(', 0, 0). trimmed ();

        //to_user ().info ((selected_filter + "   " + file_type_name).ascii());

        Text file_type;

        if (file_type_name == "Any files"    || 
            file_type_name == "Any chemical" ||
            file_type_name.isEmpty()//fix
           ) 
            file_type = "auto detect";
        else
            file_type = file_type_name;

            QStringList::Iterator it = file_names.begin();

            while (it != file_names.end()) 
            {
                QString file_name = *it;


                //std::wstring wstring = it->toStdWString ();
                //const wchar_t * fn= wstring.c_str();
                //std::wifstream in (fn);

        //std::wstring wstring = it->toStdWString ();
        //std::string string;
        //string.assign (wstring.begin(), wstring.end());
        //const char * file_name = string.c_str();

                //QByteArray ba = QFile::encodeName (file_name);
                //path () = ba.data();
                //New_model command (ba.data());

                path () = file_name;
                New_model command (file_name);

                command.execute ();
                Model & model =  Project::singleton().current_model ();
                model.load (file_name, file_type);
                //model.load (QObject::tr("D:/USER/Niki/2009/Work//MeCN.hin"), file_type);
                model.kit().visual().fit_to_screen();

                ++it;
            }
    }
}

}//MM
