#include "Qt_save.h"

#include "Qt_save_as.h"

#include "User.h"
#include "Main_window.h"
#include "Project.h"
#include "Model.h"
#include "Model_kit.h"
#include "New_model.h"
#include "Create.h"

#include <QMdiSubWindow>

namespace MM
{

void Qt_save::
execute()
{
    if (Main_window::singleton()->current_model_window () == 0)
        return;

    Model & model   = current_model();
    Storable & file = model.kit().file();
    Text file_name  = file.file_name();

    if (!file.was_defined())
        Qt_save_as().execute();

    else
    {
        bool success = model.save (write_files_with_comments ());

        if (success)
            to_user().status (Text("File ") + file_name + " saved.");
        else
        {
            Text message ("Can not save file ");
            message += file_name;
            to_user().status (message);
            to_user().error  (message);
        }
    }
}

}//MM
