#include "Qt_save_all.h"

#include "Qt_save_as.h"

#include "User.h"
#include "Main_window.h"
#include "Project.h"
#include "Model.h"
#include "Model_kit.h"
#include "New_model.h"
#include "Create.h"

#include <QMdiSubWindow>

namespace MM
{

void Qt_save_all::
execute()
{
    Project & project = Project::singleton();

    for (int i=0;  i<project.model_count();  ++i)
    {
        Model &   model = project.model(i);
        Storable & file = model.kit().file();
        Text  file_name = file.file_name();

        if (!file.was_defined())
        {
			//Project::singleton().set_current_model (model);
            model.kit().visual().set_focus ();
            Qt_save_as().execute();
        }
        else
        {
            bool success = model.save (write_files_with_comments ());

            if (success)
                to_user().status (Text("File ") + file_name + " saved.");
            else
            {
                Text message ("Can not save file ");
                message += file_name;
                to_user().status (message);
                to_user().error  (message);
            }
        }
    }
}

}//MM
