#include "Qt_save_as.h"

#include "User.h"

#include "Main_window.h"
#include "Project.h"
#include "Model.h"
#include "Model_kit.h"
#include "New_model.h"
#include "Create.h"

#include <QFileDialog>
#include <QTabBar>
#include <QMdiSubWindow>

namespace MM
{

void Qt_save_as::
execute()
{
    QFileDialog     dialog (Main_window::singleton(), "Save file as ...", path ());
    dialog.setMinimumHeight (580);
    dialog.setMinimumWidth  (950);
    dialog.setAcceptMode    (QFileDialog::AcceptSave);
    dialog.setViewMode      (QFileDialog::List);
    dialog.setFileMode      (QFileDialog::AnyFile);

    QStringList filters = list_filters (for_save);
    dialog.setFilters (filters);
    dialog.setDefaultSuffix ("mlm");

    if (dialog.exec())
    {
        QStringList file_names      = dialog.selectedFiles  ();
        selected_filter_            = dialog.selectedFilter ();
        QString     file_type_name  = 
            //selected_filter_. section('(', 0, 0). stripWhiteSpace ();
            selected_filter_. section('(', 0, 0). trimmed ();

        //to_user ().info ((selected_filter + "   " + file_type_name).ascii());

        Text file_type;

        if (file_type_name == "Any files"    || 
            file_type_name == "Any chemical" ||
            file_type_name.isEmpty()//fix
           ) 
            file_type = "auto detect";
        else
            file_type = file_type_name;

            QStringList::Iterator it = file_names.begin();

            while (it != file_names.end()) 
            {
                QString file_name = *it;
                path () = file_name;

                Text name_saved;
                Model & model = current_model ();
                model.save_as (file_name,
                                selected_filter_,
                                &name_saved,
                                write_files_with_comments ());

                int index = Main_window::singleton()->tabBar->currentIndex ();
                Main_window::singleton()->tabBar->
                    setTabText (index, QFileInfo (name_saved).fileName ());
                Main_window::singleton()->MDI_panel->activeSubWindow()->
                    setWindowTitle (name_saved);
                Main_window::singleton()->current_model_window ()->
                    setWindowTitle (name_saved);

                ++it;
            }
    }
}

}//MM
