#ifndef SAVE_H
#define SAVE_H

#ifndef CURRENT_FOLDER_H
#include "Current_folder.h"
#endif

#ifndef SAVE_AS_H
#include "Save_as.h"
#endif

namespace MM
{

class Save : public Command, protected Current_folder
{
    Form_main_window      * main_window_;//fix make * to all

public:
    explicit Save (Form_main_window *parent_widget)
        : main_window_(parent_widget) { }

    void execute()
    {
        if (Project::singleton().model_count() == 0)
            return;

        Model & model = Project::singleton().current_model();

        if (!model.kit().file().was_defined())
        {
            Save_as save_as (main_window_);
            save_as.execute();
            return;
        }

        Text file_name = model.kit().file().file_name();

        if (Project::singleton().current_model().
            save (write_files_with_comments ()))
        {
            to_user().status (Text("File ") + file_name + " saved.");
        }
        else
            to_user().warning (Text("Can not save file ") + file_name);
    }
};

}//MM

#endif //SAVE_H
