#ifndef SAVE_AS_H
#define SAVE_AS_H

#ifndef CURRENT_FOLDER_H
#include "Current_folder.h"
#endif

#include <QFileDialog>
#include <QWorkspace>
#include <QTabBar>

namespace MM
{

class Save_as : public Command, protected Current_folder
{
    Form_main_window      * main_window_;//fix make * to all
    Model                 * model_;

public:
    explicit Save_as (Form_main_window *parent_widget)
        : main_window_(parent_widget), model_(0) { }

    explicit Save_as (Form_main_window *parent_widget, Model & model)
        : main_window_(parent_widget), model_(& model) { }

    void execute()
    {
        Text individual;
        
        int k = Model_file::prototype_count();

        for (int i=0;  i<k;  ++i)
        {
            Model_file const & file_type = Model_file::prototype (i);
            
            if (file_type.support_output())
            {
                if (!individual.is_empty())
                    individual += ";;";

                individual += file_type.type_name();

                int type_name_length = file_type.type_name().length();
                for (int space=type_name_length;  space<12;  ++space)
                    individual += " ";

                individual += " (";

                int  n = file_type.extension_count();
                bool first_extension_record = true;

                for (int j=0;  j<n;  ++j)
                {
                    if (!first_extension_record)
                    {
                        individual += " ";
                    }
                    first_extension_record = false;

                    individual += "*.";
                    individual += file_type.extension(j);
                }
                
                individual += ")";
            }
        }
        Text text;
        text += "Auto         (*.*);;";
        text += individual;
        //log () << text << "\n\n";

        Text default_file_name ("newfile.mlm");
        //default_file_name += 
        //    Project::singleton().current_model().kit().file().extension();

        QString selected_filter;
        //QString file_name = Q3FileDialog::   //fix parent_widget_ or &main_window_?
        //    getSaveFileName (default_file_name.c_str(), text.c_str(), main_window_,
        //    "open file dialog", "Save as", &selected_filter);

        QString file_name = QFileDialog::getSaveFileName (
            main_window_->parent(),
            "Save as",
            path (), //path
            text.c_str(), //filter
            &selected_filter
            );

        /*QString file_name = QFileDialog::   
            getSaveFileName( 
                "newfile.pdb", 
                "Protein Data Bank     (*.pdb *.ent);;"
                "M.Dynamix     (*.mol);;"
                "M.Dynamix     (*.smol);;"
                "XYZ     (*.xyz *.xmol);;"
                "HyperChem     (*.hin);;"
                "Protein with hydrogen     (*.hhh);;",  //fix
                parent_widget_ );//*/

        if (selected_filter.isNull())//fix to all
            return;

        Text selected_filter_text, name_saved;
        selected_filter_text += selected_filter.latin1();

        if (!file_name.isEmpty())
        {
            path () = file_name;

            Model *model;
            if (model_ == 0)
                model = & Project::singleton().current_model();
            else
                model = model_;

            if (model->save_as (file_name.latin1(),
                                selected_filter_text,
                                &name_saved,
                                write_files_with_comments ())
               )
            {
                main_window_->workspace->activeWindow ()
                    //->setCaption(QFileInfo (file_name).baseName());
                    ->setCaption(name_saved.c_str());
                main_window_->tab_bar
                    //->tab(main_window_->tab_bar->currentTab())
                    ////->setText (QFileInfo (file_name).baseName());
                    //->setText (QFileInfo (name_saved.c_str()).baseName());
                    ->setTabText (main_window_->tab_bar->currentIndex(), 
                                  QFileInfo (name_saved.c_str()).baseName());
            }
        }
    }
};

}//MM

#endif //SAVE_AS_H
