#include "Qt_interface.h"

#include "Log.h"

#include "Qt_command.h"
#include "Module_void_handle.h"
#include "Module_bool_handle.h"
#include "Main_window.h"
#include "Path.h"

#include <QToolBar>
#include <QAction>

namespace MM
{
int icon_size = 32;

std::map <Text, QAction*> Qt_interface::map_;

QAction * Qt_interface::
action (Text const& name) 
{
    std::map <Text, QAction*>::iterator it = map_.find (name);
    return it == map_.end() ? 0 : it->second;
}


Command * Qt_interface::
handle_apply (Module_void_handle & handle)
{
    Qt_command       *command = new Qt_command (handle.command().orphan());

    Main_window  *new_main_window = Main_window::singleton ();                       
    
    QAction * action = new QAction (new_main_window);

    QObject::connect (action, SIGNAL(triggered()), command, SLOT(execute()));        

    if (handle.has_accelerator())
        action->setShortcut (QKeySequence (handle.accelerator()));                   

    if (handle.has_icon())
    {
        QToolBar    *tool_bar = new_main_window->tool_bar (handle.tool_bar());

        //log() << (Path::icon() + icon_size + "/" + handle.icon());
        QIcon icon = QIcon((Path::icon() + icon_size + "/" + handle.icon()));
        icon.addFile ((Path::icon() + "none-16.png"));

        action->setIcon (icon);                                                     
        
        if (handle.has_tool_tip())
            if (handle.has_accelerator())
            {
                Text text = Text(handle.tool_tip()) 
                    + " (" + handle.accelerator() + ")";
                action->setToolTip (text.c_str());                                  
            }
            else
            {
                action->setToolTip (handle.tool_tip());                             
            }

        tool_bar->addAction (action);           
    }

    if (handle.has_menu())
    {
        map_[handle.menu_item()] = action;
        action->setText (handle.menu_item());                   
        QMenu * menu = new_main_window->menu (handle.menu());
        menu->addAction (action);
    }

    return command;
}

Command_1<bool> * Qt_interface::
handle_apply (Module_bool_handle & handle)
{
    Qt_bool_command * command = new Qt_bool_command (handle.command().orphan());
    Main_window *    main_window = Main_window::singleton ();  

    QAction * action = new QAction (main_window);                          
    action->setCheckable (true);
    action->setChecked      (handle.checked ());
    command->execute        (handle.checked ());

    QObject::connect (action,   SIGNAL (triggered (bool)), 
                      command,  SLOT   (execute   (bool)));  

    if (handle.has_accelerator())
        action->setShortcut (QKeySequence (handle.accelerator()));             

    if (handle.has_icon())
    {
        QToolBar * tool_bar = main_window->tool_bar (handle.tool_bar());

        QIcon icon = QIcon((Path::icon() + icon_size + "/" + handle.icon()));
        icon.addFile ((Path::icon() + "none-16.png"));
        action->setIcon (icon);                                                    
        
        if (handle.has_tool_tip())
        {
            if (handle.has_accelerator())
            {
                Text text (handle.tool_tip());
                text += " (";
                text += handle.accelerator();
                text + ")";
                action->setToolTip (text);
            }
            else
                action->setToolTip (handle.tool_tip());
        }

        tool_bar->addAction (action);          
    }

    if (handle.has_menu())
    {
        map_[handle.menu_item()] = action;
        action->setText (handle.menu_item());                   
        QMenu * menu = main_window->menu (handle.menu());
        menu->addAction (action);
    }

    return command;
}

void Qt_interface::
handle_insert_menu_separator (Text const& menu)
{
    Main_window::singleton ()->menu (menu.c_str())->addSeparator ();
}

}//MM
