#ifndef IMAGE___QT_QIMAGE_H
#define IMAGE___QT_QIMAGE_H

#include <qimage.h>

class Image___Qt_QImage
{
    QImage image_;

public:
    Image___Qt_QImage(int width, int height);
    int             width()  const           { return image_.width (); }
    int             height() const           { return image_.height(); }

    unsigned char * scan_line( int i )
    {
        return (unsigned char *)image_.scanLine( i );
    }

    const unsigned char * scan_line( int i ) const
    {
        return (const unsigned char *)image_.scanLine( i );
    }

    void            clear( int red, 
                           int green, 
                           int blue )
    {
        image_.fill( qRgb( red, green, blue ) );
    }

    // Qt specific
    QImage &        qimage()                { return image_; }
    const QImage &  qimage() const          { return image_; }
};

#endif //IMAGE___QT_QIMAGE_H
