#include "New_model_Qt.h"

#include "Main_window.h"
#include "Model_RM_window.h"

#include "Create.h"
//#include "Form_main_window.h"
//#include "Qt_application.h"
#include "Model_RM_widget.h"
#include "Model.h"
#include "Model_kit.h"
#include "Project.h"
#include "Atom.h"
#include "Atom_kit.h"
#include "Bond.h"
#include "Bond_kit.h"
#include "OpenRM_bond.h"
//#include "OpenRM_model_view.h"

#include <qapplication.h>

namespace MM
{

New_model_impl * New_model_Qt::
clone () const
{
    return new New_model_Qt;
}

void New_model_Qt::
make_scene (Model &model, Text const & name)
{
    {   //new
        Main_window * main_window = Main_window::singleton();

        //fix move to model view
        Model_RM_window *window = new Model_RM_window (model);
        main_window->adopt_MDI_window (window, name);

        ///MDI_window->focus_in.subscribe (model.kit().view(), &Model_view::set_focus);

        model.kit().add_visual (window);
       
        Atom_kit & atom_kit = model.atom_prototype().kit();

        atom_kit.add_visual (new OpenRM_atom (atom_kit, 
            window->RM_widget_1_->object_node_, window->RM_widget_1_));

        atom_kit.add_visual (new OpenRM_atom (atom_kit, 
            window->RM_widget_2_->object_node_, window->RM_widget_2_));

        Bond_kit & bond_kit = model.bond_prototype().kit();

        bond_kit.add_visual (new OpenRM_bond (bond_kit, 
            window->RM_widget_1_->object_node_, window->RM_widget_1_));

        bond_kit.add_visual (new OpenRM_bond (bond_kit, 
            window->RM_widget_2_->object_node_, window->RM_widget_2_));

        //return;
    }

//    Form_main_window &main_window 
//        = MM::Qt_application::singleton().main_window();
//    
//    Model_RM_widget *rm_widget = new Model_RM_widget (model, 0);
//    Form_model *MDI_window = new Form_model (model, rm_widget);
//    MDI_window->setCaption (name_.c_str());
//
///*
//    //3 Form_model *MDI_window = new Form_model (main_window);
//    Form_model *MDI_window = new Form_model;
//    MDI_window->setCaption (name);
//    QRMWidget *rm_widget = new QRMWidget (MDI_window);
//    //QRMWidget *rm_widget = new QRMWidget;
//    //QGLWidget *rm_widget = new QGLWidget;
//    MDI_window->set_central_widget (rm_widget);//*/
//    MDI_window->focus_in.subscribe (model.kit().visual(), &Model_view_composite::set_focus);
//    
//    /*class Destroy_model : public Command
//    {
//        Model & model_;
//    public:  
//        explicit Destroy_model (Model & model) : model_(model) { }
//        virtual void execute () 
//        {
//            model_.erase();
//        }
//    };
//    MDI_window->destroy. subscribe (new Destroy_model (model));//*/
//   
//    main_window.add_MDI_window (MDI_window, name_.c_str());
//    model.kit().add_visual (                             
//    new OpenRM_model_view (model, *rm_widget, *MDI_window));    //fix !!!  view == Form_model
//
//    {
//        model.atom_prototype().kit().add_visual (new OpenRM_atom 
//            (model.atom_prototype().kit(), rm_widget->object_node(), rm_widget));
//    }//*/
//    MDI_window->showMaximized();
}

void New_model_Qt::
execute (Text const & name)
{
    Model *model = prototype <Model> ().clone();
    Project::singleton().adopt (model);
    make_scene  (*model, name);
    //qApp->processEvents();
}

}//MM
