#ifndef QT_COMMAND_H
#define QT_COMMAND_H

#ifndef COMMAND_H
#include "Command.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#include <qobject.h>

namespace MM
{

class Qt_command : public QObject, public Command
{
    Q_OBJECT

    Own <Command>           impl_;

public:
    Qt_command (Command * command)
        : impl_(Own <Command> (command)) { }

    Qt_command (QObject * parent, Command * command)
        : QObject(parent), impl_(Own <Command> (command)) { }

public slots:
    virtual void execute() {impl_().execute();}
};

class Qt_bool_command : public QObject, public Command_1 <bool>
{
    Q_OBJECT

    Own <Command_1 <bool> > impl_;

public:
    Qt_bool_command (Command_1 <bool> * command)
        : impl_(Own <Command_1 <bool> > (command)) { }

    Qt_bool_command (QObject * parent, Command_1 <bool> * command)
        : QObject(parent), impl_(Own <Command_1 <bool> > (command)) { }

public slots:
    virtual void execute (bool on) {impl_().execute (on);}
};

}//MM

#endif //QT_COMMAND_H
