#include "Module.h"

#include "Model.h"
#include "Model_impl.h"
#include "Model_kit.h"
#include "Project.h"
#include "New_model.h"
#include "Current_folder.h"

#include "Main_window.h"

#include "Abstracts.h"
#include "Create.h"
#include "Path.h"

namespace MM
{

class Module_base : public Module
{
    static Module_base      singleton_;
                            Module_base() ;
    void                    init ();

    Command_1 <bool> *      write_files_with_comments ()
    {
        struct Write_files_with_comments 
            : public Command_1 <bool>, protected Current_folder
        {
            void execute (bool on)  {write_files_with_comments () = on;}
        };
        return new Write_files_with_comments;
    }

    Command * close_all ()
    {
        struct Close_all : public Command
        {
            void execute ()  {Main_window::singleton()->close_all_windows();}
        };
        return new Close_all;
    }
};
Module_base  Module_base::singleton_;


Module_base::Module_base () : Module ("Base") { }

void  Module_base::
init ()
{
    adopt_command (prototype <Open> ().clone())
        .set_icon        ("File", "open.png")
        .set_tool_tip    ("Load model from file.")
        .set_accelerator ("Ctrl+O")
        .set_menu        ("&File", "&Open");

    adopt_command (new New_model)
        .set_icon        ("File", "new.png")
        .set_tool_tip    ("Create new model.")
        .set_accelerator ("Ctrl+N")
        .set_menu        ("&File", "&New");

    adopt_command (prototype <Add> ().clone())
        .set_tool_tip    ("Merge models.")
        .set_menu        ("&File", "&Add");
                         
    adopt_command (prototype <Pull_on> ().clone())
        .set_tool_tip    ("Pull on current model.")
        .set_menu        ("&File", "&Pull on");
                         

    insert_menu_separator ("&File");

    adopt_command (prototype <Synchonize_folders> ().clone())
        .set_menu        ("&File", "The same &folder", true);


    insert_menu_separator ("&File");

    adopt_command (prototype <Save_as> ().clone())
        .set_menu        ("&File", "Sa&ve as...");

    adopt_command (prototype <Save> ().clone())
        .set_icon        ("File", "save.png")
        .set_accelerator ("Ctrl+S")
        .set_menu        ("&File", "&Save");
                         
    adopt_command (prototype <Save_all> ().clone())
        .set_icon        ("File", "save_all.png")
        .set_menu        ("&File", "Save A&ll");
                         
    adopt_command (write_files_with_comments ())
        .set_menu        ("&File", "With &comments", false);

    insert_menu_separator ("&File");

    adopt_command (close_all ())
        .set_menu        ("&File", "&Close All");

    adopt_command (prototype <Exit> ().clone ())
        .set_menu        ("&File", "E&xit");

    //=======================================================

    adopt_command (prototype <Contents> ().clone())
        .set_menu        ("&Help", "&Contents");

    //adopt_command (prototype <Discuss> ().clone())
    //    .set_menu        ("&Help", "&Discuss");

    adopt_command (prototype <About> ().clone())
        .set_menu        ("&Help", "&About");

    //=======================================================

    Model_impl model;
    model.load (Path::force_field() + "FineType.mlm", "auto detect");
}

}//MM
