#include "Module.h"

#include "Peep.h"
#include "Model_RM_window.h"
#include "Main_window.h"
#include "Atom.h"
#include "Atom_kit.h"
#include "Bond_kit.h"
#include "Molecule.h"
#include "Residue.h"

#include "Project.h"
#include "Model.h"
#include "Model_kit.h"
#include "Cleaner.h"

#include "Abstracts.h"
#include "Create.h"
#include "User.h"


namespace MM
{

class Module_edit : public Module
{
    static Module_edit      singleton_;
                            Module_edit() ;
    void                    init ();
    
    void                    del_atoms ();
    void                    del_bonds ();
};
Module_edit  Module_edit::singleton_;


Module_edit::Module_edit () : Module ("Edit") { }

void  Module_edit::
init ()
{

    adopt_command (prototype <Show_geometry>().clone())
        .set_menu        ("&Edit", "&Geometry")
        //.set_accelerator ("Ctrl+E")
        .set_tool_tip    ("Geometry: distances, angles, dihedrals.")
        .set_icon        ("Edit", "geometry.png");

    adopt_command (prototype <Show_geometry>().clone())
        .set_menu ("&Analyse", "&Geometry");


    insert_menu_separator ("&Edit");

    adopt_command (create_command (*this, &Module_edit::del_atoms))
        .set_menu        ("&Edit", "&Delete atoms")
        .set_accelerator ("Delete")
        //.set_icon        ("Edit", "out.png")
        ;

    adopt_command (create_command (*this, &Module_edit::del_bonds))
        .set_menu        ("&Edit", "Delete selected &bonds")
        .set_icon        ("Edit", "delete_bonds.png")
        ;

    insert_menu_separator ("&Edit");

    adopt_command (prototype <Show_model_movement>().clone())
        .set_menu        ("&Edit", "&Move model")
        .set_icon        ("Edit", "out.png");


    //insert_menu_separator ("&File");

}

void  Module_edit::
del_atoms ()
{
    Model & model = Project::singleton().current_model();
    Cleaner cleaner(model);

    for (int i=0;  i<model.atom_count();  ++i)
    {
        Atom & atom = model.atom (i);

        if (atom.kit().is_selected())
            cleaner.add (atom);
    }
}


void  Module_edit::
del_bonds ()
{
    Model & model = Project::singleton().current_model();
    Cleaner cleaner(model);

    for (int i=0;  i<model.bond_count();  ++i)
    {
        Bond & bond = model.bond (i);

        if (bond.kit().is_selected())
            cleaner.add (bond);
    }
}

}//MM
