#include "Test.h"

#include "Aminoacid_name.h"

namespace MM
{

class Aminoacid_name_test : public Test
{
    Aminoacid_name *link;

public:
    Aminoacid_name_test( const Text & suite_name ) : Test( suite_name ) { }
    
    void run()
    {
        test_20();              count_tests();
        test_case();            count_tests();
    }

    void test_20()
    {
        //"O" HYP
        
        TEST ("", Aminoacid_name::one_letter ("ALA") == "A");
        TEST ("", Aminoacid_name::one_letter ("ARG") == "R");
        TEST ("", Aminoacid_name::one_letter ("ASN") == "N");
        TEST ("", Aminoacid_name::one_letter ("ASP") == "D");
        TEST ("", Aminoacid_name::one_letter ("VAL") == "V");
        TEST ("", Aminoacid_name::one_letter ("HIS") == "H");
        TEST ("", Aminoacid_name::one_letter ("GLY") == "G");
        TEST ("", Aminoacid_name::one_letter ("GLN") == "Q");
        TEST ("", Aminoacid_name::one_letter ("GLU") == "E");
        TEST ("", Aminoacid_name::one_letter ("ILE") == "I");
        TEST ("", Aminoacid_name::one_letter ("LEU") == "L");
        TEST ("", Aminoacid_name::one_letter ("LYS") == "K");
        TEST ("", Aminoacid_name::one_letter ("MET") == "M");
        TEST ("", Aminoacid_name::one_letter ("PRO") == "P");
        TEST ("", Aminoacid_name::one_letter ("SER") == "S");
        TEST ("", Aminoacid_name::one_letter ("TYR") == "Y");
        TEST ("", Aminoacid_name::one_letter ("THR") == "T");
        TEST ("", Aminoacid_name::one_letter ("TRP") == "W");
        TEST ("", Aminoacid_name::one_letter ("PHE") == "F");
        TEST ("", Aminoacid_name::one_letter ("CYS") == "C");

        TEST ("", Aminoacid_name::one_letter ("Alanine")       == "A");
        TEST ("", Aminoacid_name::one_letter ("Arginine")      == "R");
        TEST ("", Aminoacid_name::one_letter ("Asparagine")    == "N");
        TEST ("", Aminoacid_name::one_letter ("Aspartic acid") == "D");
        TEST ("", Aminoacid_name::one_letter ("Valine")        == "V");
        TEST ("", Aminoacid_name::one_letter ("Histidine")     == "H");
        TEST ("", Aminoacid_name::one_letter ("Glycine")       == "G");
        TEST ("", Aminoacid_name::one_letter ("Glutamine")     == "Q");
        TEST ("", Aminoacid_name::one_letter ("Glutamic acid") == "E");
        TEST ("", Aminoacid_name::one_letter ("Isoleucine")    == "I");
        TEST ("", Aminoacid_name::one_letter ("Leucine")       == "L");
        TEST ("", Aminoacid_name::one_letter ("Lysine")        == "K");
        TEST ("", Aminoacid_name::one_letter ("Methionine")    == "M");
        TEST ("", Aminoacid_name::one_letter ("Proline")       == "P");
        TEST ("", Aminoacid_name::one_letter ("Serine")        == "S");
        TEST ("", Aminoacid_name::one_letter ("Tyrosine")      == "Y");
        TEST ("", Aminoacid_name::one_letter ("Threonine")     == "T");
        TEST ("", Aminoacid_name::one_letter ("Tryptophan")    == "W");
        TEST ("", Aminoacid_name::one_letter ("Phenylalanine") == "F");
        TEST ("", Aminoacid_name::one_letter ("Cysteine")      == "C");

        TEST ("", Aminoacid_name::one_letter ("a") == "A");
        TEST ("", Aminoacid_name::one_letter ("r") == "R");
        TEST ("", Aminoacid_name::one_letter ("n") == "N");
        TEST ("", Aminoacid_name::one_letter ("d") == "D");
        TEST ("", Aminoacid_name::one_letter ("v") == "V");
        TEST ("", Aminoacid_name::one_letter ("h") == "H");
        TEST ("", Aminoacid_name::one_letter ("g") == "G");
        TEST ("", Aminoacid_name::one_letter ("q") == "Q");
        TEST ("", Aminoacid_name::one_letter ("e") == "E");
        TEST ("", Aminoacid_name::one_letter ("i") == "I");
        TEST ("", Aminoacid_name::one_letter ("l") == "L");
        TEST ("", Aminoacid_name::one_letter ("k") == "K");
        TEST ("", Aminoacid_name::one_letter ("m") == "M");
        TEST ("", Aminoacid_name::one_letter ("p") == "P");
        TEST ("", Aminoacid_name::one_letter ("s") == "S");
        TEST ("", Aminoacid_name::one_letter ("y") == "Y");
        TEST ("", Aminoacid_name::one_letter ("t") == "T");
        TEST ("", Aminoacid_name::one_letter ("w") == "W");
        TEST ("", Aminoacid_name::one_letter ("f") == "F");
        TEST ("", Aminoacid_name::one_letter ("c") == "C");

        TEST ("", Aminoacid_name::one_letter ("aaa") == Aminoacid_name::wrong );

        TEST ("", Aminoacid_name::three_letter ("a") == "Ala");
        TEST ("", Aminoacid_name::three_letter ("r") == "Arg");
        TEST ("", Aminoacid_name::three_letter ("n") == "Asn");
        TEST ("", Aminoacid_name::three_letter ("d") == "Asp");
        TEST ("", Aminoacid_name::three_letter ("v") == "Val");
        TEST ("", Aminoacid_name::three_letter ("h") == "His");
        TEST ("", Aminoacid_name::three_letter ("g") == "Gly");
        TEST ("", Aminoacid_name::three_letter ("q") == "Gln");
        TEST ("", Aminoacid_name::three_letter ("e") == "Glu");
        TEST ("", Aminoacid_name::three_letter ("i") == "Ile");
        TEST ("", Aminoacid_name::three_letter ("l") == "Leu");
        TEST ("", Aminoacid_name::three_letter ("k") == "Lys");
        TEST ("", Aminoacid_name::three_letter ("m") == "Met");
        TEST ("", Aminoacid_name::three_letter ("p") == "Pro");
        TEST ("", Aminoacid_name::three_letter ("s") == "Ser");
        TEST ("", Aminoacid_name::three_letter ("y") == "Tyr");
        TEST ("", Aminoacid_name::three_letter ("t") == "Thr");
        TEST ("", Aminoacid_name::three_letter ("w") == "Trp");
        TEST ("", Aminoacid_name::three_letter ("f") == "Phe");
        TEST ("", Aminoacid_name::three_letter ("c") == "Cys");

        TEST ("", Aminoacid_name::three_letter ("ALA") == "Ala");
        TEST ("", Aminoacid_name::three_letter ("ARG") == "Arg");
        TEST ("", Aminoacid_name::three_letter ("ASN") == "Asn");
        TEST ("", Aminoacid_name::three_letter ("ASP") == "Asp");
        TEST ("", Aminoacid_name::three_letter ("VAL") == "Val");
        TEST ("", Aminoacid_name::three_letter ("HIS") == "His");
        TEST ("", Aminoacid_name::three_letter ("GLY") == "Gly");
        TEST ("", Aminoacid_name::three_letter ("GLN") == "Gln");
        TEST ("", Aminoacid_name::three_letter ("GLU") == "Glu");
        TEST ("", Aminoacid_name::three_letter ("ILE") == "Ile");
        TEST ("", Aminoacid_name::three_letter ("LEU") == "Leu");
        TEST ("", Aminoacid_name::three_letter ("LYS") == "Lys");
        TEST ("", Aminoacid_name::three_letter ("MET") == "Met");
        TEST ("", Aminoacid_name::three_letter ("PRO") == "Pro");
        TEST ("", Aminoacid_name::three_letter ("SER") == "Ser");
        TEST ("", Aminoacid_name::three_letter ("TYR") == "Tyr");
        TEST ("", Aminoacid_name::three_letter ("THR") == "Thr");
        TEST ("", Aminoacid_name::three_letter ("TRP") == "Trp");
        TEST ("", Aminoacid_name::three_letter ("PHE") == "Phe");
        TEST ("", Aminoacid_name::three_letter ("CYS") == "Cys");

        TEST ("", Aminoacid_name::three_letter ("Alanine")       == "Ala");
        TEST ("", Aminoacid_name::three_letter ("Arginine")      == "Arg");
        TEST ("", Aminoacid_name::three_letter ("Asparagine")    == "Asn");
        TEST ("", Aminoacid_name::three_letter ("Aspartic acid") == "Asp");
        TEST ("", Aminoacid_name::three_letter ("Valine")        == "Val");
        TEST ("", Aminoacid_name::three_letter ("Histidine")     == "His");
        TEST ("", Aminoacid_name::three_letter ("Glycine")       == "Gly");
        TEST ("", Aminoacid_name::three_letter ("Glutamine")     == "Gln");
        TEST ("", Aminoacid_name::three_letter ("Glutamic acid") == "Glu");
        TEST ("", Aminoacid_name::three_letter ("Isoleucine")    == "Ile");
        TEST ("", Aminoacid_name::three_letter ("Leucine")       == "Leu");
        TEST ("", Aminoacid_name::three_letter ("Lysine")        == "Lys");
        TEST ("", Aminoacid_name::three_letter ("Methionine")    == "Met");
        TEST ("", Aminoacid_name::three_letter ("Proline")       == "Pro");
        TEST ("", Aminoacid_name::three_letter ("Serine")        == "Ser");
        TEST ("", Aminoacid_name::three_letter ("Tyrosine")      == "Tyr");
        TEST ("", Aminoacid_name::three_letter ("Threonine")     == "Thr");
        TEST ("", Aminoacid_name::three_letter ("Tryptophan")    == "Trp");
        TEST ("", Aminoacid_name::three_letter ("Phenylalanine") == "Phe");
        TEST ("", Aminoacid_name::three_letter ("Cysteine")      == "Cys");

        TEST ("", Aminoacid_name::one_letter ("") == Aminoacid_name::wrong );

        TEST ("", Aminoacid_name::full ("a") == "Alanine")      ;
        TEST ("", Aminoacid_name::full ("r") == "Arginine")     ;
        TEST ("", Aminoacid_name::full ("n") == "Asparagine")   ;
        TEST ("", Aminoacid_name::full ("d") == "Aspartic acid");
        TEST ("", Aminoacid_name::full ("v") == "Valine")       ;
        TEST ("", Aminoacid_name::full ("h") == "Histidine")    ;
        TEST ("", Aminoacid_name::full ("g") == "Glycine")      ;
        TEST ("", Aminoacid_name::full ("q") == "Glutamine")    ;
        TEST ("", Aminoacid_name::full ("e") == "Glutamic acid");
        TEST ("", Aminoacid_name::full ("i") == "Isoleucine")   ;
        TEST ("", Aminoacid_name::full ("l") == "Leucine")      ;
        TEST ("", Aminoacid_name::full ("k") == "Lysine")       ;
        TEST ("", Aminoacid_name::full ("m") == "Methionine")   ;
        TEST ("", Aminoacid_name::full ("p") == "Proline")      ;
        TEST ("", Aminoacid_name::full ("s") == "Serine")       ;
        TEST ("", Aminoacid_name::full ("y") == "Tyrosine")     ;
        TEST ("", Aminoacid_name::full ("t") == "Threonine")    ;
        TEST ("", Aminoacid_name::full ("w") == "Tryptophan")   ;
        TEST ("", Aminoacid_name::full ("f") == "Phenylalanine");
        TEST ("", Aminoacid_name::full ("c") == "Cysteine")     ;

        TEST ("", Aminoacid_name::full ("Ala") == "Alanine")      ;
        TEST ("", Aminoacid_name::full ("Arg") == "Arginine")     ;
        TEST ("", Aminoacid_name::full ("Asn") == "Asparagine")   ;
        TEST ("", Aminoacid_name::full ("Asp") == "Aspartic acid");
        TEST ("", Aminoacid_name::full ("Val") == "Valine")       ;
        TEST ("", Aminoacid_name::full ("His") == "Histidine")    ;
        TEST ("", Aminoacid_name::full ("Gly") == "Glycine")      ;
        TEST ("", Aminoacid_name::full ("Gln") == "Glutamine")    ;
        TEST ("", Aminoacid_name::full ("Glu") == "Glutamic acid");
        TEST ("", Aminoacid_name::full ("Ile") == "Isoleucine")   ;
        TEST ("", Aminoacid_name::full ("Leu") == "Leucine")      ;
        TEST ("", Aminoacid_name::full ("Lys") == "Lysine")       ;
        TEST ("", Aminoacid_name::full ("Met") == "Methionine")   ;
        TEST ("", Aminoacid_name::full ("Pro") == "Proline")      ;
        TEST ("", Aminoacid_name::full ("Ser") == "Serine")       ;
        TEST ("", Aminoacid_name::full ("Tyr") == "Tyrosine")     ;
        TEST ("", Aminoacid_name::full ("Thr") == "Threonine")    ;
        TEST ("", Aminoacid_name::full ("Trp") == "Tryptophan")   ;
        TEST ("", Aminoacid_name::full ("Phe") == "Phenylalanine");
        TEST ("", Aminoacid_name::full ("Cys") == "Cysteine")     ;

        TEST ("", Aminoacid_name::full ("Alanine")       == "Alanine")      ;
        TEST ("", Aminoacid_name::full ("Arginine")      == "Arginine")     ;
        TEST ("", Aminoacid_name::full ("Asparagine")    == "Asparagine")   ;
        TEST ("", Aminoacid_name::full ("Aspartic acid") == "Aspartic acid");
        TEST ("", Aminoacid_name::full ("Valine")        == "Valine")       ;
        TEST ("", Aminoacid_name::full ("Histidine")     == "Histidine")    ;
        TEST ("", Aminoacid_name::full ("Glycine")       == "Glycine")      ;
        TEST ("", Aminoacid_name::full ("Glutamine")     == "Glutamine")    ;
        TEST ("", Aminoacid_name::full ("Glutamic acid") == "Glutamic acid");
        TEST ("", Aminoacid_name::full ("Isoleucine")    == "Isoleucine")   ;
        TEST ("", Aminoacid_name::full ("Leucine")       == "Leucine")      ;
        TEST ("", Aminoacid_name::full ("Lysine")        == "Lysine")       ;
        TEST ("", Aminoacid_name::full ("Methionine")    == "Methionine")   ;
        TEST ("", Aminoacid_name::full ("Proline")       == "Proline")      ;
        TEST ("", Aminoacid_name::full ("Serine")        == "Serine")       ;
        TEST ("", Aminoacid_name::full ("Tyrosine")      == "Tyrosine")     ;
        TEST ("", Aminoacid_name::full ("Threonine")     == "Threonine")    ;
        TEST ("", Aminoacid_name::full ("Tryptophan")    == "Tryptophan")   ;
        TEST ("", Aminoacid_name::full ("Phenylalanine") == "Phenylalanine");
        TEST ("", Aminoacid_name::full ("Cysteine")      == "Cysteine")     ;

    }

    void test_case()
    {
        TEST ("", Aminoacid_name::one_letter ("ala") == "A" );
        TEST ("", Aminoacid_name::one_letter ("ALA") == "A" );
        TEST ("", Aminoacid_name::one_letter ("aLA") == "A" );
        TEST ("", Aminoacid_name::full ("CySteIne")  == "Cysteine")     ;
    }
};

Aminoacid_name_test test_aminoacid_name ("correctness");

}//MM
