#ifndef CRYSTAL_BUILDER_H
#define CRYSTAL_BUILDER_H

#ifndef GRID_3D_H
#include "Grid_3D.h"
#endif

namespace MM
{
class Model;
class Vector_3D;
class Atom_group;

class Crystal_builder
{
public:
    virtual ~Crystal_builder () {}
    virtual Crystal_builder *   clone (Model & model) const =0;

    //virtual Grid_3D <Model*>    grid  () =0;
    virtual Model &             model () =0;

    virtual Vector_3D const &   a () const =0;
    virtual Vector_3D const &   b () const =0;
    virtual Vector_3D const &   c () const =0;

    virtual     void            set (Vector_3D const & a,
                                     Vector_3D const & b,
                                     Vector_3D const & c) =0;

    virtual double              a_mod () const =0;//fix remove
    virtual double              b_mod () const =0;
    virtual double              c_mod () const =0;

    virtual double              alpha () const =0;//fix remove
    virtual double              beta  () const =0;
    virtual double              gamma () const =0;

    virtual void                set (double new_a,//fix remove
                                     double new_b,
                                     double new_c,
                                     double new_alpha,
                                     double new_beta,
                                     double new_gamma) =0;//*/

    virtual int                 a_copies () const =0;
    virtual int                 b_copies () const =0;
    virtual int                 c_copies () const =0;
    virtual void                set_number_of_copies (int a, int b, int c) =0;

    virtual bool                use_PBC     () const =0;
    virtual void                set_use_PBC (bool use) =0;

    //virtual bool                show_images     () const =0;
    //virtual void                set_show_images (bool show) =0;

    virtual bool                show_border  () const =0;
    virtual char const *        border_style () const =0;

    virtual void                expand_model     () =0;
    virtual void                convert_from_fractional_to_cartesian () =0;
    virtual void                fit_box () =0;

    virtual Atom_group &        cell_copy       () =0;
    virtual Atom_group &        cell_node       () =0;
    virtual Atom_group &        octahedral_hole () =0;
    virtual Atom_group &        tetrahedral_hole() =0;
};

}//MM

#endif //CRYSTAL_BUILDER_H
