#ifndef DYNAMIC_SINGLETON_H
#define DYNAMIC_SINGLETON_H

template <typename T>
class Dynamic_singleton
{
    static T *& pointer ()
    {
        static T *instance = 0;
        return instance;
    }

public:
    static bool exist ()        {return pointer () != 0;}
    static bool not_exist ()    {return pointer () == 0;}

    static T * singleton ()
    {
        if (pointer () == 0)
            pointer () = new T ();

        return pointer ();
    }

    ~Dynamic_singleton()        {pointer () = 0;}
};

#endif //DYNAMIC_SINGLETON_H
