#ifndef EDITOR_H
#define EDITOR_H

namespace MM
{
class Text;

class Editor
{
static Editor * last_;
//static bool     busy_;

public:
    virtual ~Editor();

    virtual Text const& name () const =0;

    virtual void        start_editing  ();
    virtual void        finish_editing ();
    virtual void        cancel_editing ();

    //static bool         previous_is_busy ()          {return busy_;}
    //static void         set_busy (bool on)  {busy_= on;}

protected:
    virtual void        handle_start_editing    () =0;
    virtual void        handle_finish_editing   () =0;
    virtual void        handle_cancel_editing   () =0;
    virtual void        handle_activate_editing () =0;

private:
    bool    is_different_editor () const {return this != last_;}
};

}//MM

#endif //EDITOR_H
