#ifndef SEQUENCE_EDITOR_H
#define SEQUENCE_EDITOR_H

#ifndef OWN_H
//#include "Own.h"
#endif

#ifndef ARBITRARY_MOLECULAR_GROUP_H
#include "Arbitrary_molecular_group.h"
#endif

#ifndef MODEL_EVENT_H
#include "Model_event.h"
#endif

#ifndef COMMAND_H
#include "Command.h"
#endif

#ifndef EDITOR_H
#include "Editor.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{
class Model;
class Residue;

class Sequence_editor : protected DbC, public Editor
{
    Model &                         model_;
    Arbitrary_molecular_group       molecules_;
    int                             max_sequence_length_;
    Command_1 <Model_event::Hint> & reset_;

public:
    // Editor
    virtual Text const&     name () const;
    virtual void            handle_start_editing    ();
    virtual void            handle_finish_editing   ();
    virtual void            handle_cancel_editing   ();
    virtual void            handle_activate_editing ();
    //

    explicit Sequence_editor (Model & model);
    virtual ~Sequence_editor ();
    
    void                reset (Model_event::Hint hint 
                                = Model_event::Structure_changed);

    //Molecular_sequence const & molecular_type () const                     {return type_sequence_();}
    int                 molecule_count () const {return molecules_.molecule_count();}
    Molecule &          molecule  (int n)       {return molecules_.molecule(n);}
    Molecule const &    molecule  (int n) const {return molecules_.molecule(n);}
    int                 max_sequence   () const {return max_sequence_length_;}
    Residue &           residue (int mol, int res);

    void                new_molecule (Text const& file_name);
    int                 append       (int mol, int res, Text const& file_name);

protected:
    void                chain (Residue &left, Residue &right, double distance);
};

}//MM

#endif //SEQUENCE_EDITOR_H
