#ifndef FINE_TYPE_IMPL_H
#define FINE_TYPE_IMPL_H

#include "Fine_type.h"

#include <string>
#include <map>
#include <set>

namespace MM
{

class Fine_type_impl : public Fine_type
{
    std::map <int, std::string>                                     id_to_name_;
    std::map <std::string, int>                                     name_to_id_;
    int                             counter_;

    //        fine_type              in           mm_type 
    std::map <std::string, std::map <std::string,
        std::pair<std::string, double> > >                          mm_map_;
    std::set <std::string>                                          ff_set_;

    Fine_type_impl ();
    Fine_type_impl (Fine_type_impl const&);
    void operator = (Fine_type_impl const&);

public:
    static Fine_type_impl & singleton ();

    bool            handle_exist (char const* name);
    int             handle_id    (char const* name);
    char const*     handle_name  (int id);

    char const*     handle_to    (char const * fine_type,
                                  char const * in,
                                  double     * charge);

    void            handle_map   (char const * fine_type,
                                  char const * mm_type,
                                  double       charge,
                                  char const * in);

    void            handle_force_field_list (Array <Text> & list);

    void            handle_add   (char const* name);
    //void            handle_erase (int id);
    //void            handle_erase (char const* name);
};

}//MM

#endif //FINE_TYPE_IMPL_H
