/*
    ChemCon - molecular mechanics and molecular graphics
    Copyright (C) 1998-2002  Alexei Nikitin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef FLAG_H
#define FLAG_H

class Flag
{
public: 
    int     is        (Flag flag) const {return flag & value_;}
    int     is_not    (Flag flag) const {return !(flag & value_);}
    void    set       (Flag flag)       {value_ |=  flag;}
    void    clear     (Flag flag)       {value_ &= ~flag;}
    void    clear_all ()                {value_ =   0;}

    operator  unsigned long () {return value_;} //fix

    Flag () : value_(0) { }
    //~Flag() { /*value_ = 0;*/ }
    Flag (unsigned long r) : value_(r) { }
    //Flag( const char *  )                                       { } //???

private:
//    Flag & operator = (const Flag &);

    unsigned long               value_;
};

enum { connection_mark = 1 };//fix

#endif //FLAG_H

