#ifndef MM_FLAG_H
#define MM_FLAG_H

#ifndef FLAG_H
#include "Flag.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

namespace MM
{

class MM_Flag : public Flag
{
public:
    enum {
            selected=0x1000,
            backbone=0x2000
         };

    Text    text () const
    {
        Text result;

        if (is (selected))
            result += "s";

        if (is (backbone))
            result += "b";

        if (result.size() == 0)
            result += "-";

        return result;
    }

    void    set_text (Text const & new_flag)     //fix
    {
        if (new_flag.size() >= 1)
        {
            if (new_flag[0] == 's')
                set (selected);
    
            if (new_flag[0] == 'b')
                set (backbone);

            if (new_flag.size() >= 2)
            {
                if (new_flag[1] == 'b')
                    set (backbone);
            }
        }
    }
};

}//MM

#endif //MM_FLAG_H
