/*
    ChemCon - molecular mechanics and molecular graphics
    Copyright (C) 1998-2002  Alexei Nikitin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MOT_H
#define MOT_H

#ifndef ARRAY_H
#include "Array.h"
#endif


class Micro_object_type;

class Micro_object_type
{
    char                  **type_;
    int                     counter_;
    MM::Array <double>      mass_;

public:
    enum {none = -1,  undefined_type = 0,  any_type = 1};

    virtual
   ~Micro_object_type();
    Micro_object_type();

    void                    load (const char * fileName);
    void                    save (const char * fileName) const;
    //void          add( char * t );

    unsigned int            atoi (const char * t)  const;//fix return int
    const char *            itoa (int t)           const;
    double                  mass (int t)           const {return mass_[t];}
    int                     fit  (int t1, int t2)  const;
    static int              undefined ()       {return Micro_object_type::undefined_type;}

    int                     get_counter( void )     const;

private:
    Micro_object_type   (const Micro_object_type &);
    Micro_object_type &  operator = ( const Micro_object_type &);
};

Micro_object_type & mot ();

inline
int  Micro_object_type::
fit (int t1, int t2) const
{
    return  ( t1 == t2        ||
    t1 == any_type ||
    t2 == any_type   ) ? 1 : 0;
}

#endif // MOT_H


