/*
    This file is part of the MolMeccano cross-platform C++ chemical library.

    Copyright (C) 2001-2003 Alexei Nikitin.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "AMBER_Van_der_Waals_energy.h"

#include "Atom.h"
#include "Atom_kit.h"
#include "Force_field.h"

namespace MM
{

double AMBER_Van_der_Waals_energy::
handle_value () const
{
    double distance_2 = length_.value_2 ();
    double distance_6 = distance_2 * distance_2 * distance_2;
    double result     = A_ / (distance_6 * distance_6) - B_ / distance_6;
    return result;
}

/*AMBER_Van_der_Waals_energy::
AMBER_Van_der_Waals_energy (const Atom & atom1, const Atom & atom2 )
:
    length_(atom1, atom2)
{
    Force_field & force_field = Force_field::singleton ();
    force_field.VdW (atom1.kit().mm_type(), atom2.kit().mm_type(), A_, B_);
}//*/

AMBER_Van_der_Waals_energy::
AMBER_Van_der_Waals_energy (const Atom & atom1, const Atom & atom2,
                            double A, double B)
:
     A_(A), B_(B), length_(atom1.position(), atom2.position())
{
}

}//MM

