/*
    This file is part of the MolMeccano cross-platform C++ chemical library.

    Copyright (C) 2001-2003 Alexei Nikitin.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AMBER_VAN_DER_WAALS_ENERGY_H
#define AMBER_VAN_DER_WAALS_ENERGY_H

#ifndef VAN_DER_WAALS_ENERGY_H
#include "Van_der_Waals_Energy.h"
#endif

#ifndef LENGTH_H
#include "Length.h"
#endif

namespace MM
{

class Atom;

class AMBER_Van_der_Waals_energy : public Van_der_Waals_Energy
{
    double      A_;
    double      B_;
    Length      length_; // Angstrom

public:
    //AMBER_Van_der_Waals_energy (const Atom & atom1, const Atom & atom2);
    AMBER_Van_der_Waals_energy (const Atom & atom1, const Atom & atom2,
                                double A, double B);

protected:
    virtual double handle_value() const ;
};

}//MM

#endif //AMBER_VAN_DER_WAALS_ENERGY_H

