#include "AMBER_angle_energy.h"

#include "Atom.h" 
#include "Atom_kit.h" 
#include "Force_field.h" 

namespace MM
{

double AMBER_angle_energy::
handle_value () const
{
    double theta  = valent_angle_.value();
    double delta  = theta - equilibrium_value();
    double result = force_constant() * delta * delta;
    return result;
}

/*AMBER_angle_energy::
AMBER_angle_energy (const Atom & atom1,
                    const Atom & atom2,
                    const Atom & atom3)
:
    valent_angle_(atom1, atom2, atom3)
{
    Force_field & force_field = Force_field::singleton();
    force_field.angle (atom1.kit().mm_type(), 
                       atom2.kit().mm_type(), 
                       atom3.kit().mm_type(),
                       force_constant_, equilibrium_value_);
}//*/

AMBER_angle_energy::
AMBER_angle_energy (const  Atom & atom1,
                    const  Atom & atom2,
                    const  Atom & atom3,
                    double force_constant,
                    double equilibrium_value)
:
    valent_angle_      (atom1, atom2, atom3),
    force_constant_    (force_constant),
    equilibrium_value_ (equilibrium_value)
{
}

}//MM
