/*
    This file is part of the MolMeccano cross-platform C++ chemical library.

    Copyright (C) 2001,2002 Alexei Nikitin.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AMBER_ANGLE_ENERGY_H
#define AMBER_ANGLE_ENERGY_H

#ifndef ANGLE_ENERGY_H
#include "Angle_energy.h"
#endif

#ifndef VALENT_ANGLE_H
#include "Valent_angle.h"
#endif

//#ifndef ANGLE_H
//#include "Angle.h"
//#endif

namespace MM
{
class Atom;

class AMBER_angle_energy : public Angle_energy
{
public:
    AMBER_angle_energy (const Atom & atom1,
                        const Atom & atom2,
                        const Atom & atom3,
                        double force_constant,
                        double equilibrium_value);

    /*AMBER_angle_energy( const Atom & atom1,
                        const Atom & atom2,
                        const Atom & atom3 );//*/

    double          force_constant    () const {return force_constant_;   }
    double          equilibrium_value () const {return equilibrium_value_;}
    const Atom &    first_atom  () const {return valent_angle_.first_atom ();}
    const Atom &    second_atom () const {return valent_angle_.second_atom();}
    const Atom &    third_atom  () const {return valent_angle_.third_atom ();}

protected:
    virtual double handle_value () const ;

private:
    //Angle           valent_angle_;      // radian
    Valent_angle    valent_angle_;      // radian
    double          force_constant_;    // kcal / mol radian 2
    double          equilibrium_value_; // radian
};

}//MM

#endif //AMBER_ANGLE_ENERGY_H




