#include "AMBER_bond_energy.h"

#include "Atom.h"
#include "Atom_kit.h"
#include "Force_field.h"

namespace MM
{

/*AMBER_bond_energy::
AMBER_bond_energy (const Atom & atom1, const Atom & atom2)
:
    length_(atom1, atom2)
{
    Force_field & force_field = Force_field::singleton();
    force_field.bond( atom1.kit().mm_type(), atom2.kit().mm_type(), 
                      force_constant_, equilibrium_distance_ );
}//*/

double AMBER_bond_energy::
handle_value () const
{
    double length = length_.value();
    double delta  = length - equilibrium_distance();
    double result = force_constant() * delta * delta;
    return result;
}

AMBER_bond_energy::
AMBER_bond_energy (const Atom & atom1, const Atom & atom2,
                   double force_constant, double equilibrium_distance)
:
    length_(atom1, atom2),
    force_constant_(force_constant),
    equilibrium_distance_(equilibrium_distance)
{
}

}//MM

