/*
    This file is part of the MolMeccano cross-platform C++ chemical library.

    Copyright (C) 2001,2002 Alexei Nikitin.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AMBER_BOND_ENERGY_H
#define AMBER_BOND_ENERGY_H

#ifndef BOND_ENERGY_H
#include "Bond_energy.h"
#endif

#ifndef BOND_LENGTH_H
#include "Bond_length.h"
#endif

namespace MM
{

class MM_atom;

class AMBER_bond_energy : 
    public Bond_energy
{
public:
    AMBER_bond_energy (const  Atom & atom1,   const Atom & atom2,
                       double force_constant, double equilibrium_distance);
    //AMBER_bond_energy (const Atom & atom1, const Atom & atom2);
    double          force_constant      () const {return force_constant_;}
    double          equilibrium_distance() const {return equilibrium_distance_;}
    const Atom &    first_atom          () const {return length_.first_atom ();}
    const Atom &    second_atom         () const {return length_.second_atom();}

    //AMBER_bond_energy () {}
    //AMBER_bond_energy const& operator = (AMBER_bond_energy const&r) {return r;}

protected:
    virtual double handle_value () const ;

private:
    Bond_length length_;                // Angstrom
    double      force_constant_      ;  // kcal / mol angstrom 2
    double      equilibrium_distance_;  // angstrom
};

}//MM

#endif //AMBER_BOND_ENERGY_H




