#include "AMBER_torsion_energy.h"

#include "Force_field.h"
#include "Atom.h"
#include "Atom_kit.h"
#include <cmath>

namespace MM
{

double AMBER_torsion_energy::
handle_value () const
{
    double result = 0;
    double phi    = torsion_angle_.value();

    int terms = fourier_terms();

    for (int k=0;  k<terms;  ++k)
    {
        double v_2   = force_constant (k);
        double phase = phase_angle    (k);
        int    n     = n_fold_symmetry(k);
        double mult  = multiplicity   (k);

        result += v_2 * (1 + cos (n * phi - phase)) / mult;
    }

    return result;
}

AMBER_torsion_energy::
AMBER_torsion_energy( const Atom & atom1,
                      const Atom & atom2,
                      const Atom & atom3,
                      const Atom & atom4,
                      const Array <Force_field::Torsions> *parameters )
:
    ref_(parameters),
    torsion_angle_(atom1, atom2, atom3, atom4)
{
    //Force_field & force_field = Force_field::singleton();
    //ref_ = force_field.torsion (atom1.kit().mm_type(), atom2.kit().mm_type(),
    //                            atom3.kit().mm_type(), atom4.kit().mm_type());
}
/*
AMBER_torsion_energy::
AMBER_torsion_energy( const MM_atom & atom1,
                    const MM_atom & atom2,
                    const MM_atom & atom3,
                    double force_constant,
                    double equilibrium_value )
:
    valent_angle_( atom1, atom2, atom3 ),
    force_constant_( force_constant ),
    equilibrium_value_( equilibrium_value )
{
}
//*/

}//MM
