#include "Bond_energy_CT_CT_amber.h"

#include "Bond_length.h"
#include "Atom.h"

namespace MM
{

Bond_energy_CT_CT_amber::
Bond_energy_CT_CT_amber( const Atom & atom1, const Atom & atom2 )
:
atom1_(atom1), atom2_(atom2)
{
}

double Bond_energy_CT_CT_amber::handle_value() const
{
    double result = 0.0;
    //CT    CT	310.0	1.526	"JCC,7,(1986),230;"	AA,	SUGARS
    //fix Bond_length r(atom1_,atom2_);
    //fix double distance = r.value();

    double distance = ( atom1_.x() - atom2_.x() ) * ( atom1_.x() - atom2_.x() ) +
    ( atom1_.y() - atom2_.y() ) * ( atom1_.y() - atom2_.y() ) +
    ( atom1_.z() - atom2_.z() ) * ( atom1_.z() - atom2_.z() ) ;

    result = 310.0 * ( distance - 1.526 ) * ( distance - 1.526 );

    return result;
}

}//MM
