/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ENERGY_H
#define ENERGY_H

#ifndef FUNCTION_H
#include "Function.h"
#endif

#ifndef METHOD_H
#include "Method.h"
#endif

#ifndef DISABLING_H
#include "Disabling.h"
#endif

namespace MM
{

class Energy : 
    public Method, 
    public Function, 
    public Disabling
{
protected:
    virtual double handle_value() const =0;

public:
    virtual double value() const { return is_on() ? handle_value() : 0.0; }
};

}//MM

#endif //ENERGY_H
