/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "MM_energy.h"

namespace MM
{

MM_energy::~MM_energy()
{
}

double MM_energy::
handle_value() const
{
    REQUIRE( "Was initialized", electrostatic_energy_.was_initialized() &&
                                Van_der_Waals_Energy_.was_initialized() &&
                                bond_energy_         .was_initialized() &&
                                angle_energy_        .was_initialized() &&
                                dihedral_energy_     .was_initialized() );

    return  electrostatic_energy_().value() +
            Van_der_Waals_Energy_().value() +
            bond_energy_().         value() +
            angle_energy_().        value() +
            dihedral_energy_().     value();
}

void MM_energy::
set_electrostatic_energy( Electrostatic_energy *ptr )
{
    electrostatic_energy_.adopt( ptr );
}

void MM_energy::
set_Van_der_Waals_Energy( Van_der_Waals_Energy *ptr )
{
    Van_der_Waals_Energy_.adopt( ptr );
}

void MM_energy::
set_bond_energy( Bond_energy *ptr )
{
    bond_energy_.adopt( ptr );
}

void MM_energy::
set_angle_energy( Angle_energy *ptr )
{
    angle_energy_.adopt( ptr );
}

void MM_energy::
set_dihedral_energy( Dihedral_energy *ptr )
{
    dihedral_energy_.adopt( ptr );
}

}//MM
