/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MM_ENERGY_H
#define MM_ENERGY_H

#ifndef ENERGY_H
#include "Energy.h"
#endif

#ifndef ELECTROSTATIC_ENERGY_H
#include "Electrostatic_energy.h"
#endif

#ifndef VAN_DER_WAALS_ENERGY_H
#include "Van_der_Waals_Energy.h"
#endif

#ifndef BOND_ENERGY_H
#include "Bond_energy.h"
#endif

#ifndef ANGLE_ENERGY_H
#include "Angle_energy.h"
#endif

#ifndef DIHEDRAL_ENERGY_H
#include "Dihedral_energy.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

namespace MM
{

class MM_energy : public Energy,  protected DbC
{
public:
    virtual             ~MM_energy () =0;
    virtual double      handle_value () const;

    //Nonbonded Interactions
    //Intramolecular Interactions

    void                set_electrostatic_energy (Electrostatic_energy *ptr);
    void                set_Van_der_Waals_Energy (Van_der_Waals_Energy *ptr);
    void                set_bond_energy          (Bond_energy          *ptr); 
    void                set_angle_energy         (Angle_energy         *ptr);
    void                set_dihedral_energy      (Dihedral_energy      *ptr);

private:    
    Own <Electrostatic_energy>      electrostatic_energy_;
    Own <Van_der_Waals_Energy>      Van_der_Waals_Energy_;
    Own <Bond_energy         >      bond_energy_;
    Own <Angle_energy        >      angle_energy_;
    Own <Dihedral_energy     >      dihedral_energy_;
};

}//MM

#endif //MM_ENERGY_H
