/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "Test_MM_energy.h"

#include "Void_electrostatic_energy.h"
#include "Void_Van_der_Waals_Energy.h"
#include "Test_bond_energy.h"
#include "Test_angle_energy.h"
#include "Void_dihedral_energy.h"

namespace MM
{

Test_MM_energy::Test_MM_energy
    (Array_of< AMBER_bond_energy > * adopt_bond_lengths )
{
    set_electrostatic_energy( new Void_electrostatic_energy() );
    set_Van_der_Waals_Energy( new Void_Van_der_Waals_Energy() );
    set_bond_energy         ( new Test_bond_energy( adopt_bond_lengths ) );
    set_angle_energy        ( new Test_angle_energy(  ) );
    set_dihedral_energy     ( new Void_dihedral_energy() );
}

}//MM
