/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "Test_bond_energy.h"

#include "Array_of.h"

namespace MM
{

double Test_bond_energy::handle_value() const
{
    FIX;
    double result = 0.0;

    /*for( int i=0; bond_lengths_().size();  ++i )
    {
        MM_bond_length & length = bond_lengths_()[i];
        double delta = length.value() - length.equilibrium_distance();
        result += length.force_constant() * delta * delta;
    }//*/

    
    return result;
}


Test_bond_energy::Test_bond_energy
( Array_of< AMBER_bond_energy > * adopt_bond_lengths )
:   bond_lengths_( adopt_bond_lengths )
{
}

}//MM
