#include "Van_der_Waals_energy_CT_CT_amber.h"

#include "Atom.h"

#include  <cmath>

namespace MM
{

double Van_der_Waals_energy_CT_CT_amber::handle_value() const
{
    //  Type        R*      Epsilon            Reference
    //  CT          1.9080  0.1094             Spellmeyer
    //
    // R(ij)* = R(i)* + R(j)*                       = 1.9080 + 1.9080       = 3.816
    //
    //                                          1/2
    // Epsilon(ij) = ( Epsilon(i) * Epsilon(j) )                            = 0.1094
    //
    //                                 12
    // A(ij) = Epsilon(ij) * ( R(ij)* )             = 0.1094 * 3.816^12     = 1043080.2307033
    //                                     6
    // B(ij) = 2 * Epsilon(ij) * ( R(ij)* )         = 2 * 0.1094 * 3.816^6  = 675.61224748799
    //

	double distance=( atom1_.x() - atom2_.x() ) * ( atom1_.x() - atom2_.x() ) +
	                ( atom1_.y() - atom2_.y() ) * ( atom1_.y() - atom2_.y() ) +
	                ( atom1_.z() - atom2_.z() ) * ( atom1_.z() - atom2_.z() ) ;

	double A = pow(2*1.9080,12)*0.1094; 
	double B = 2*pow(2*1.9080,6)*0.1094;

	double distance_6 = pow(distance,6);
    double result = A/(distance_6*distance_6) - B/distance_6; 
    return result;
}

Van_der_Waals_energy_CT_CT_amber::
Van_der_Waals_energy_CT_CT_amber(const Atom & atom1, const Atom & atom2)
: atom1_(atom1), atom2_(atom2)
{
}

}//MM
