/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef IMAGE_H
#define IMAGE_H

/** Image is a heir of platform specific 2 dimensional surface.
Parent should have next methods:

class Image
{
    int             width()  const;
    int             height() const;

    unsigned char * scan_line( int i );
    const unsigned char * scan_line( int i ) const;

    void            clear( int red, int green, int blue );
};
//*/

#ifdef __BORLANDC__

    #ifndef IMAGE___BORLAND_TBITMAP_H
    #include "Image___Borland_TBitmap.h"
    #endif

    class Image : public Image___Borland_TBitmap
    {
    public:
        Image( Graphics::TBitmap *image ) : Image___Borland_TBitmap( image ) { }
    };

#endif

//#ifdef QT_THREAD_SUPPORT
#ifdef QT_GUI_LIB

    #ifndef IMAGE___QT_QIMAGE_H
    #include "Image___Qt_QImage.h"
    #endif

    class Image : public Image___Qt_QImage
    {
    public:
        Image( int width, int height ) : Image___Qt_QImage( width, height ) { }
//        Image( QImage *image ) : Image___Qt_QImage( image ) { }
    };

#endif



//fir to Image___Microsoft_DIB
/*class Image
{
    int                         width_;
    int                         height_;
    unsigned char               * pixels_;

public:
    Image( unsigned char * pixels, int width, int height );
    virtual ~Image();

    int                         width()  { return width_ ; }
    int                         height() { return height_; }
    unsigned char *             pixels() { return pixels_; }

private:
    Image( const Image & );
    const Image & operator = ( const Image & );
};
//*/

#endif //INCLUDED_image
