/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Material.h"


Material::Material()
  : /*radius( 1.8 ), */
//    Ka( 1.0 ), Kd( 1.0 ), Ks( 0.15 ), n( 20.0 ), K_transparency( 0.0 ),
    Ka_( 204 ), Kd_( 153 ), Ks_( 38 ), n_( 20 ), 
//    R( 1.0 ), G( 1.0 ), B( 1.0 ), B_and_W( 1.0 ),
    R_( 70 ), G_( 255 ), B_( 70 ), B_and_W_( 155 ), 
    film_width_( 0.0 ), K_transparency_( 0.0 ),
    film_R_( 0 ), film_G_( 0 ), film_B_( 0 ), film_B_and_W_( 0 )
{
}

Material::Material( const Material & r )
  : /*radius( r.radius ), */
    Ka_( r.Ka_ ), Kd_( r.Kd_ ), Ks_( r.Ks_ ), n_( r.n_ ),
    R_( r.R_ ), G_( r.G_ ), B_( r.B_ ), B_and_W_( r.B_and_W_ ),
    film_width_( r.film_width_ ),
    K_transparency_( r.K_transparency_ ),
    film_R_( r.film_R_ ), film_G_( r.film_G_ ),
    film_B_( r.film_B_ ), film_B_and_W_( r.film_B_and_W_ )
{
}

const Material & Material::
operator = ( const Material & r )
{
    if( this != &r )
    {
        //radius          = r.radius;
        film_width_     = r.film_width_;
        Ka_             = r.Ka_;
        Kd_             = r.Kd_;
        Ks_             = r.Ks_;
        n_              = r.n_;
        K_transparency_ = r.K_transparency_;
        R_              = r.R_;
        G_              = r.G_;
        B_              =  r.B_;
        B_and_W_        = r.B_and_W_;
        film_R_         = r.film_R_;
        film_G_         = r.film_G_;
        film_B_         = r.film_B_;
        film_B_and_W_   = r.film_B_and_W_;
    }
    return  *this;
}
