/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MATERIAL_H
#define MATERIAL_H

//                Light models
// .  "   " || .384
// D.F. Rogers "Procedural Elements for Computer Graphics"
//
// N1
//                K * Il                               n
//  I = Ia * Ka + ------ * ( Kd * cos theta  + Ks * cos theta  )
//                D + K
// N3
//        K                                                n
//  I = ----- [ Ia * Ka + Il * ( Kd * cos theta  + Ks * cos theta  ) ]
//      D + K
//

class  Material
{
public: //fix
    int                             Ka_, Kd_, Ks_, n_;
    int                             R_, G_, B_, B_and_W_;

    double                          film_width_, K_transparency_;
    int                             film_R_, film_G_, film_B_, film_B_and_W_;

    Material();
    Material( const Material & ); //fix private
    const Material & operator = ( const Material & );

    int                             r() const { return R_; }
    int                             g() const { return G_; }
    int                             b() const { return B_; }
    void                            set_color (int R, int G, int B) 
                                        {R_=R; G_=G; B_=B;}
};

#endif//MATERIAL_H
