/*
    ChemCon - molecular mechanics and molecular graphics
    Copyright (C) 1998-2002  Alexei Nikitin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef WIN32
#pragma warning (disable : 4996)
#endif

#include "ViewObj.h"

#include "C_str.h"
#include "Model.h"
#include "Atom.h"
#include "Element.h"
#include "View_atom_type.h"

#include <string.h>
#include <stdio.h>

//-------- View_object ------------------

//namespace MM
//{

View_object::~View_object() { selection_flag_=0; x_=0; y_=0; z_=0; X_=0; Y_=0; Z_=0; }
View_abstract_sphere::~View_abstract_sphere() { radius_=0; }
View_sphere::~View_sphere() { ix_=0; iy_=0; iz_=0; }

//-------- View_atom_type ---------------
/*
View_atom_type::View_atom_type()
  {
    radius_ = 0;
    strcpy( name_, "" );
  }

View_atom_type::~View_atom_type()
  {
    radius_ = 0;
    strcpy( name_, "" );
  }

View_atom_type::View_atom_type( const View_atom_type & r )
  : Material( r )
  {
    radius_                = r.radius_;
    strcpy( name_, r.name_ );
  }

const View_atom_type & View_atom_type::
operator = ( const View_atom_type & r )
  {
    if( this != &r )
      {
        *(( Material* )this) = r;
        radius_                = r.radius_;
        strcpy( name_, r.name_ );
      }
    return  *this;
  }

void  View_atom_type::
init( char * str )
  {
    int    result;
    char   buf[80];
    double tmp;

    radius_         = 1.7;
    film_width_     = 0.0;
    R_              = 255;
    G_              = 20;
    B_              = 147;
    B_and_W_        = 200;
    film_R_         = 0;
    film_G_         = 0;
    film_B_         = 255;
    Ka_             = 0.8*255;
    Kd_             = 1.2*255;
    Ks_             = 0.2*255;
    n_              = 20;
    K_transparency_ = 0.5;

    result = substr( str, buf, 0, 8 );
      if( result == 0 ) return;
    sscanf( buf, "%s", &buf );
      if( strlen( buf  ) > 5 ) throw;

    strcpy( name_, buf );

    result = substr( str, buf, 8, 8 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &radius_ );

    result = substr( str, buf, 16, 8 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &film_width_ );

    result = substr( str, buf, 24, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &R_ );

    result = substr( str, buf, 28, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &G_ );

    result = substr( str, buf, 32, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &B_ );

    result = substr( str, buf, 36, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &B_and_W_ );

    result = substr( str, buf, 40, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &film_R_ );

    result = substr( str, buf, 44, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &film_G_ );

    result = substr( str, buf, 48, 3 );  
      if( result == 0 ) return;
    sscanf( buf, "%i", &film_B_ );

    result = substr( str, buf, 52, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &film_B_and_W_ );

    result = substr( str, buf, 56, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &tmp );
    Ka_ = (int)(tmp*255);

    result = substr( str, buf, 61, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &tmp );
    Kd_ = (int)(tmp*255);

    result = substr( str, buf, 66, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &tmp );
    Ks_ = (int)(tmp*255);

    result = substr( str, buf, 71, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &tmp );
    n_ = (int)tmp;

    result = substr( str, buf, 76, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &K_transparency_ );
  }
//*/
//-------- View_Atom --------------------

void  View_Atom::
set_attributes()
  {
    x_ = atom_->x();
    y_ = atom_->y();
    z_ = atom_->z();
    radius_ = view_type_->radius();
    material_ = *view_type_;
  }

View_Atom::View_Atom (MM::Atom * at)
  : atom_( at ), view_type_( NULL )
  {
    //element_to_a( Atom->element, symbol );
    strcpy( symbol_, atom_->element().c_str() );
  }

View_Atom::View_Atom()
  : atom_( NULL ), view_type_( NULL )
  {
    symbol_[0] = '\0';
  }

View_Atom::~View_Atom()
  {
    atom_      = NULL;
    view_type_ = NULL;
    symbol_[0] = '\0';
  }

View_Atom::View_Atom( const View_Atom & r )
  : View_abstract_sphere( r )
  {
    atom_       = r.atom_;
    view_type_ = r.view_type_;
    symbol_[0] = r.symbol_[0];
    symbol_[1] = r.symbol_[1];
    symbol_[2] = r.symbol_[2];
    symbol_[3] = r.symbol_[3];
    symbol_[4] = r.symbol_[4];
    symbol_[5] = r.symbol_[5];
    label_     = r.label_;
  }

const View_Atom & View_Atom::
operator = ( const View_Atom & r )
  {
    if( this != &r )
      {
        *(( View_abstract_sphere* )this) = r;
        atom_       = r.atom_;
        view_type_ = r.view_type_;
        symbol_[0] = r.symbol_[0];
        symbol_[1] = r.symbol_[1];
        symbol_[2] = r.symbol_[2];
        symbol_[3] = r.symbol_[3];
        symbol_[4] = r.symbol_[4];
        symbol_[5] = r.symbol_[5];
        label_     = r.label_;
      }
    return  *this;
  }

//-------- View_Bond ---------------

void  View_Bond::
set_attributes()
  {
    
  }

View_Bond::View_Bond()
  : bond_( NULL ), atom_X_( NULL ), atom_Y_( NULL )
  {
  }

View_Bond::View_Bond( MM::Bond * base_bond )
  : bond_( base_bond )
  {
    //atom_X = &(bond->get_atom_X());
    //atom_Y = &bond->get_atom_Y();
  }

View_Bond::~View_Bond()
  {
    bond_   = NULL;
    atom_X_ = NULL;
    atom_Y_ = NULL;
  }

View_Bond::View_Bond( const View_Bond & r )
  : View_abstract_line( r ),
    bond_( r.bond_ ),
    atom_X_( r.atom_X_ ),
    atom_Y_( r.atom_Y_ )
  {
  }

const View_Bond & View_Bond::
operator = ( const View_Bond & r )
  {
    if( this != &r )
      {
        *(( View_abstract_line* ) this) = r;

        bond_   = r.bond_;
        atom_X_ = r.atom_X_;
        atom_Y_ = r.atom_Y_;
      }
    return *this;
  }

//------------------------------------------------------

//}//MM
