/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef WIN32
#pragma warning (disable : 4996)
#endif

#include "View_atom_type.h"

#include "C_str.h"
#include "Flaw.h"

#include <stdio.h>

//namespace MM
//{

View_atom_type::View_atom_type()
{
    radius_ = 0;
    //strcpy( name_, "" );
}

View_atom_type::~View_atom_type()
{
    radius_ = 0;
    //strcpy( name_, "" );
}

View_atom_type::View_atom_type( const View_atom_type & r )
  : Material( r )
{
    radius_                = r.radius_;
    //strcpy( name_, r.name_ );
    name_ = r.name_;
}

const View_atom_type & View_atom_type::
operator = ( const View_atom_type & r )
{
    if( this != &r )
    {
        *(( Material* )this) = r;
        radius_                = r.radius_;
        //strcpy( name_, r.name_ );
        name_ = r.name_;
    }
    return  *this;
}

void  View_atom_type::
init( char * str )
{
    int    result;
    char   buf[80];
    double tmp;

    radius_         = 1.7;
    film_width_     = 0.0;
    R_              = 255;
    G_              = 20;
    B_              = 147;
    B_and_W_        = 200;
    film_R_         = 0;
    film_G_         = 0;
    film_B_         = 255;
    //Ka_             = (int)0.8*255;
    //Kd_             = (int)1.2*255;
    //Ks_             = (int)0.2*255;
    //n_              = 20;
    Ka_             = (int)1.0*255;
    Kd_             = (int)1.2*255;
    Ks_             = (int)0.0*255;
    n_              = 30;
    K_transparency_ = 0.5;

    result = substr( str, buf, 0, 8 );
      if( result == 0 ) return;
//fix    sscanf( buf, "%s", &buf );
    sscanf( buf, "%s", buf );
//      if( strlen( buf  ) > 5 ) FLAW (buf);

    //strcpy( name_, buf );
    name_ = buf;

    result = substr( str, buf, 8, 8 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &radius_ );

    result = substr( str, buf, 16, 8 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &film_width_ );

    result = substr( str, buf, 24, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &R_ );

    result = substr( str, buf, 28, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &G_ );

    result = substr( str, buf, 32, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &B_ );

    result = substr( str, buf, 36, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &B_and_W_ );

    result = substr( str, buf, 40, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &film_R_ );

    result = substr( str, buf, 44, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &film_G_ );

    result = substr( str, buf, 48, 3 );  
      if( result == 0 ) return;
    sscanf( buf, "%i", &film_B_ );

    result = substr( str, buf, 52, 3 );
      if( result == 0 ) return;
    sscanf( buf, "%i", &film_B_and_W_ );

    result = substr( str, buf, 56, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &tmp );
    Ka_ = (int)(tmp*255);

    result = substr( str, buf, 61, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &tmp );
    Kd_ = (int)(tmp*255);

    result = substr( str, buf, 66, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &tmp );
    Ks_ = (int)(tmp*255);

    result = substr( str, buf, 71, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &tmp );
    n_ = (int)tmp;

    result = substr( str, buf, 76, 5 );
      if( result == 0 ) return;
    sscanf( buf, "%lg", &K_transparency_ );
}

//}//MM
