/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef  VIEW_ATOM_TYPE_H
#define  VIEW_ATOM_TYPE_H

#ifndef  MATERIAL_H
#include "Material.h"
#endif

#ifndef  TEXT_H
#include "Text.h"
#endif

//namespace MM
//{

class View_atom_type : public Material
{
//    char                          name_[6]; //fix
    MM::Text                      name_;
    double                        radius_;

public:

    View_atom_type();
    ~View_atom_type();
    View_atom_type( const View_atom_type & );//fix
    const View_atom_type & operator = ( const View_atom_type & );

    //int                            operator == ( const VAtom_types & v ) const;
    //int                            operator != ( const VAtom_types & v ) const;
    //int                            operator < ( const VAtom_types & v ) const;

    void                            init (char * str);
    const char *                    name  () const {return name_.c_str();}
    double                          radius() const {return radius_;}
    void                            set_radius (double radius) {radius_ = radius;}
};

//}//MM

#endif //VIEW_ATOM_TYPE_H
