/* 
    This file is part of the ChemCon molecular mechanics 
    and molecular graphics program.

    Copyright (C) 1997-2002  Alexei Nikitin 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "View_atom_type_manager.h"

#include "Log.h"

#include "View_atom_type.h"
//#include "resource.h"         //fix remove
#include "Path.h"
#include "Text.h"
#include "File_input.h"

#include <string.h>
#include <stdio.h>

namespace MM
{

View_atom_type & View_atom_type_manager::
type(const char * name)
{
    for(int i=0;  i<type_.size();  ++i )
        if( !strcmp( name, type_[i].name() ) )
            return type_[i];

    //log() << name;
    FLAW (Text("Type '") + name + "' was not found.");
}

View_atom_type_manager::View_atom_type_manager()
{
    // Load atom types table from disk
//    int  i;
    char str[256], first_word[82];//, *result;
    View_atom_type  vatype;
    //type_.increase( 200 );
    bool success;

    //FilePtr    fp( "vatoms.cnf", "rt" );
    Text path( Path::parameters() );
    path += "vatoms.cnf";
    File_input input( path.c_str() );

    do
    {
        //result = fgets( str, 256, fp );
        success = input.next_line( str, 255 );
        sscanf( str, "%s", first_word );
        if( !strcmp( first_word, "BEGIN" ) )  break;
    }
//    while( result != NULL );
    while( success );

    do
    {
        memset( str, ' ', 255 );
        //result = fgets( str, 256, fp );
        success = input.next_line( str, 255 );
        sscanf( str, "%s", first_word );
        if( !strcmp( first_word, "END" ) )  break;
        if( first_word[0] == '/' && first_word[1] == '/' )  continue;

        vatype.init( str );
        //i = type_.add( vatype );
        type_.push_back( vatype );
        //atom_type_ptr.set( vatype.name, &(atom_type[i]) );
    }
//    while( result != NULL );
    while( success );
}

View_atom_type_manager & View_atom_type_manager::
singleton ()
{
    static View_atom_type_manager  instance;
    return instance;
}

}//MM
