/*
    ChemCon - molecular mechanics and molecular graphics
    Copyright (C) 1998-2002  Alexei Nikitin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef Z_BUFFER_H
#define Z_BUFFER_H

class Z_buffer
{
    Z_buffer( const Z_buffer & );


    void operator = ( const Z_buffer & );

    friend class G3D_output;
    bool mem_flag_;
    int                       **Value_;
    //      int                          *Value_;
    int                         width_;
    int                         height_;

public:
    int                         get( int x, int y )
                                        { return Value_[ x ] [ y ]; }
    void                        set( int x, int y, int v )
                                        { Value_[ x ] [ y ] = v; }
    //      int                          get( int x, int y )          { return
    // Value_[x+y*width_]; }
    //      void                        set( int x, int y, int v )  {
    // Value_[x+y*width_] = v; }

    int                         get_width() { return width_; }
    int                         get_height() { return height_; }

    Z_buffer();
    Z_buffer( int w, int h, int bg_v = 0 )  { init( w, h, bg_v ); }
    ~Z_buffer()                             { destroy(); }

    void                        init( int w, int h, int bg_v = 0 );
    void                        destroy();
    void                        update( int w, int h )
    {
        /*destroy();*/
        init( w, h );
    }

    void                        clear( int v = 0 );
    void                        clear( int left, int right, int top,
                                       int bottom, int v = 0 );
    void                        crude_clear( int left, int right, int top,
                                             int bottom, int resolution );
};

/*
inline  int  Z_buffer::
get( int x, int y )
  { // return Value_[x][y];
    __asm
    {
    mov         eax,dword ptr [this]
    mov         ecx,dword ptr [eax]         // *Value_
    mov         edx,dword ptr [x]
    mov         eax,dword ptr [ecx+edx*4]
    mov         edx,dword ptr [y]
    mov         eax,dword ptr [eax+edx*4]
    }
  }  */

/*
inline  void  Z_buffer::
set( int x, int y, int v )
  { // Value_[x][y] = v;
    __asm
    {
    mov         eax,dword ptr [this]
    mov         ecx,dword ptr [eax]
    mov         edx,dword ptr [x]
    mov         eax,dword ptr [ecx+edx*4]
    mov         ecx,dword ptr [y]
    mov         edx,dword ptr [v]
    mov         dword ptr [eax+ecx*4],edx
    }
  }  */

#endif //Z_BUFFER_H
