/*
    ChemCon - molecular mechanics and molecular graphics
    Copyright (C) 1998-2002  Alexei Nikitin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef DEFS_H
#define DEFS_H

//#define         TEST_HI
#define         TEST_LO     

//typedef unsigned char   BYTE;
typedef double          real;
//typedef float          real;

//#ifdef _MSC_VER
//#ifdef __WATCOMC__
//#ifdef __BORLANDC__

#ifdef __WATCOMC__
typedef int       bool;
#endif

//fix to
namespace Constant
{
    const double normal_temperature = 298.15; // K
    const double normal_pressure    = 1.;   // atm
    
    /////////////////////////////////////////////////////////////////////////
    // AKMA units (Angstroms, Kilocalories / Mole, Atomic mass units)

    // Length
    const double angstrom_to_m              = 1e-010; 
    const double m_to_angstrom              = 1. / angstrom_to_m;
    // Energy
    const double kcal_per_mol_to_J_per_mol  = 4186.;
    //const double kcal_per_mol_to_J_per_mol  = 4186.8;
    const double J_per_mol_to_kcal_per_mol  = 1. / kcal_per_mol_to_J_per_mol; 

    const double kcal_to_kJ  = 4.186;
    //const double kcal_per_mol_to_J_per_mol  = 4.1868;
    const double kJ_to_kcal  = 1. / kcal_to_kJ; 

    const double Hartree_to_kcal  = 627.509608;
    const double kcal_to_Hartree  = 1. / Hartree_to_kcal; 

    // Mass
    const double amu_to_kg                  = 1.661e-027; 
    const double kg_to_amu                  = 1. / amu_to_kg; 
    // Charge
    const double electron_to_C              = 1.602e-019; 
    const double C_to_electron              = 1. / electron_to_C; 
    // Time
    const double time_unit_to_sec           = 4.888821e-014; 
    const double sec_to_time_unit           = 1. / time_unit_to_sec; 
    const double time_unit_to_psec          = 4.888821e-002; 
    const double psec_to_time_unit          = 1. / time_unit_to_psec; 
    // Force
    const double kcal_per_mol_angstrom_to_N = 6.95e-001; 
    const double N_to_kcal_per_mol_angstrom = 1. / kcal_per_mol_angstrom_to_N; 

    const double Kb                         = 1.987191e-003; 
    //const double lI4PiEps0                  = 3.320716e002; 
    const double lI4PiEps0                  = 3.3205382e002; 
    const double Water_dielectric_permittivity = 78.3;

    // AKMA units
    /////////////////////////////////////////////////////////////////////////

}

#define   __E__             2.71828182845904523536

#define   __Pi__            3.14159265358979323846
                         // 3.1415926535897932384626433832795
                         // 3.14159265358979323846264338327
                         // 3.141592653589793238462643383279502884197169399375
                         // 3.1415926535897932384626433832795028841971693993751058209749445923078164062862 

#define   _R_               8.31484 // J / Mol * K
//#define   RT_kJ           2.47782 // kJ / Mol 
#define   Joule_kCal        4184
#define   Joule_Cal         4.184

//#define   EPS0              332.052 
#define   EPS0              332.0636 
//#define FACEL             332.0636*CAL2JOULE    /* (sqrt(ONE_4PI_EPS0)) */ gromacs
//#define EPS0              332.0716           //   Simulating Hamiltonian Dynamics. p.291

#define   BUF_SIZE           256

#endif//DEFS_H

