/*
    ChemCon - molecular mechanics and molecular graphics
    Copyright (C) 1998-2002  Alexei Nikitin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Mach_eps.h"

#include <math.h>

float    f_mach_eps;
double  d_mach_eps;
float    f_mach_eps_2;
double  d_mach_eps_2;
float    f_mach_eps_3;
double  d_mach_eps_3;
float    f_mach_eps_4;
double  d_mach_eps_4;

T_Mach_eps::T_Mach_eps()
  {
    for( f_mach_eps = 1;  1 + f_mach_eps != 1;  f_mach_eps/=2 );
    f_mach_eps *= 10;
    for( d_mach_eps = 1;  1 + d_mach_eps != 1;  d_mach_eps/=2 );
    d_mach_eps *= 10;
    f_mach_eps_2 = (float)sqrt( f_mach_eps );
    d_mach_eps_2 = sqrt( d_mach_eps );
    f_mach_eps_3 = (float)pow( f_mach_eps_2, 2.0f/3.0f );
    d_mach_eps_3 = pow( d_mach_eps_2, 2.0/3.0 );
    f_mach_eps_4 = (float)sqrt( f_mach_eps_2 );
    d_mach_eps_4 = sqrt( d_mach_eps_2 );
  }

//fix
//namespace {
T_Mach_eps  __MACH_EPS__;
//}
