// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#ifndef ATOM_H
#define ATOM_H

#ifndef ATOM_BOND_MANAGER_H
#include "Atom_bond_manager.h"
#endif

#ifndef MATERIAL_POINT_H
#include "Material_point.h"
#endif

#ifndef ELEMENT_H
#include "Element.h"
#endif

#ifndef OWNER_H
#include "Owner.h"
#endif

#ifndef LIVING_FRAME_H
#include "Living_frame.h"
#endif

namespace MM
{
class Atom_kit;
class Bond;
class ID;

class Atom
:
    public      Living_frame,
    public      Material_point,
    protected   Atom_bond_manager
{
public:
    Connections <Atom>          connections_;

    Atom_bond_manager &         interface_for(Bond const *){return*this;}

    static Atom &               none();

    virtual Atom_kit &          kit () =0;
    virtual Atom_kit const &    kit () const =0;

    virtual ID const &          id () const =0;
    virtual bool                has_local_id () const =0;//fix to all
    virtual Text const &        local_id     () const =0;
    virtual void                set_local_id (Text const &) const =0;

    virtual bool                is_backbone () const = 0;

    virtual double              charge () const =0;
    virtual void                set_charge (double charge) =0;

    virtual Element const &     element () const =0;
    virtual void                set_element (Element e) =0;

    virtual Atom *              clone   () const =0;
    virtual Atom *              clone   (Element const &) const =0;


    virtual double              x       () const =0;
    virtual double              y       () const =0;
    virtual double              z       () const =0;

    virtual void                set_x   (double x) =0;
    virtual void                set_y   (double y) =0;
    virtual void                set_z   (double z) =0;

    virtual Atom &              bound      (int i) =0;
    virtual Atom const &        bound      (int i) const =0;
    virtual Bond &              bond       (int i)       =0;
    virtual Bond const &        bond       (int i) const =0;
    virtual int                 bound_count ()     const =0;
    virtual bool                bound_with (Atom const&, int *bond=0) const =0;
    virtual bool                not_bound_with (Atom const &) const =0;

    virtual void                erase();
};

}//MM

#endif //ATOM_H
