#ifndef ATOM_EVENT_H
#define ATOM_EVENT_H

#ifndef EVENT_H
#include "Event.h"
#endif

namespace MM
{

class Atom_event
{
    Event       moved_;
    Event       charge_changed_;
    Event       element_changed_;

public:
    void    moved ()                                                            {moved_.publish ();}
    void    when_moved (Command * to_do)                                        {moved_.subscribe (to_do);}

    void    charge_changed ()                                                   {charge_changed_.publish ();}
    void    when_charge_changed (Command * to_do)                               {charge_changed_.subscribe (to_do);}

    void    element_changed ()                                                  {element_changed_.publish ();}
    void    when_element_changed (Command * to_do)                              {element_changed_.subscribe (to_do);}
};

}//MM

#endif //ATOM_EVENT_H
