#include "Test.h"

#include "Atom_grid.h"
#include "Atom_kit.h"
#include "Model.h"
#include "Own.h"
#include "Create.h"
#include "Path.h"

namespace MM
{

class Atom_grid_test : public Test
{
    Atom_grid *link;

public:
    Atom_grid_test (const Text& suite_name) : Test (suite_name) { }

    void run()
    {
        test_C20();          count_tests();
    }

    void test_C20();
};

void Atom_grid_test::
test_C20()
{
    Own <Model>     model (prototype <Model> (). clone ());
    model().load (Path::tests() + "C20.hin");

    Atom_grid grid (model());

    int i, count;
    Atom_grid::Near group (grid, model().atom(9).position(), 2.5);

    count = group.atom_count();
    for (i=0;  i<count;  ++i)
        group.atom(i).kit().flag().set (1);

    count = model().atom_count();
    for (i=0;  i<count;  ++i)
    {
        Length distance (model().atom(9).position(), 
                         model().atom(i).position());

        double value = distance.value();

        if (model().atom(i).kit().flag().is (1))
            ;//TEST ("", value <= (5 + 2.5));
        else 
            TEST ("",  value > 2.5);
    }//*/
}

Atom_grid_test test_atom_grid ("correctness");

}//MM
