#include "Atom_numerator.h"

#include "Atom.h"
#include "Atom_group.h"
#include "Atom_kit.h"

namespace MM
{

Atom_numerator::
Atom_numerator (Atom_group const& group)
:
    group_(group)
{
    int count = group_.atom_count();

    for (int i=0;  i<count;  ++i)
    {
        CHECK ("Atom is not numbered somebody else.",
            group_.atom(i).kit().number() < 0);

        group_.atom(i).kit().set_number(i);
    }
}

Atom_numerator::
~Atom_numerator ()
{
    #ifndef NDEBUG
    int count = group_.atom_count();

    for (int i=0;  i<count;  ++i)
    {
        CHECK ("Atom is numbered by this numerator.",
            group_.atom(i).kit().number() >= 0);

        group_.atom(i).kit().set_number(-1);
    }
    #endif
}

}//MM

