#ifndef BASE_ATOM_H
#define BASE_ATOM_H

namespace MM
{
class Element;

namespace Base
{

class Atom
{
public:    
    //static Atom *              create (Element element);

    virtual ~Atom();
    virtual const Element &    element () const =0;
    virtual Atom *             clone   () const =0;
    virtual Atom *             clone   (const Element &) const =0;

    virtual void                    set_element (Element e) =0;

    virtual double                  x       () const =0;
    virtual double                  y       () const =0;
    virtual double                  z       () const =0;

    virtual void                    set_x   (double x) =0;
    virtual void                    set_y   (double y) =0;
    virtual void                    set_z   (double z) =0;

protected:
    Atom();

private:
    Atom (const Atom &);
    const Atom & operator = (const Atom &);
};

}//Base
}//MM

#endif //BASE_ATOM_H
